package com.xforceplus.ultraman.app.jccqyy.controller;


/**
 * 预制发票表feign客户端
 *
 * @author ultraman
 * @date 2022-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccqyy.entity.PreInvoiceBatch;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface PreInvoiceBatchFeignApi {

  /**
   * 通过id查询预制发票表
   * @param  id
   * @return R
   */
  @GetMapping("/preInvoiceBatch/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增预制发票表
   * @param preInvoiceBatch 预制发票表
   * @return R
   */
  @PostMapping("/preInvoiceBatch/add")
  public R save(@RequestBody PreInvoiceBatch preInvoiceBatch);

  /**
   * 修改预制发票表
   * @param preInvoiceBatch 预制发票表
   * @return R
   */
  @PostMapping("/preInvoiceBatch/update")
  public R updateById(@RequestBody PreInvoiceBatch preInvoiceBatch);

  /**
   * 通过id删除预制发票表
   * @param  id
   * @return R
   */
  @DeleteMapping("/preInvoiceBatch/del/{id}" )
  public R removeById(@PathVariable Long id);

}