package com.xforceplus.ultraman.app.jccqyy.controller;


/**
 * 进项实体发票feign客户端
 *
 * @author ultraman
 * @date 2022-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccqyy.entity.PurchaserInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface PurchaserInvoiceFeignApi {

  /**
   * 通过id查询进项实体发票
   * @param  id
   * @return R
   */
  @GetMapping("/purchaserInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增进项实体发票
   * @param purchaserInvoice 进项实体发票
   * @return R
   */
  @PostMapping("/purchaserInvoice/add")
  public R save(@RequestBody PurchaserInvoice purchaserInvoice);

  /**
   * 修改进项实体发票
   * @param purchaserInvoice 进项实体发票
   * @return R
   */
  @PostMapping("/purchaserInvoice/update")
  public R updateById(@RequestBody PurchaserInvoice purchaserInvoice);

  /**
   * 通过id删除进项实体发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/purchaserInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}