package com.xforceplus.ultraman.app.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 不合规内容枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-21
 */
public enum ComplianceContentEnum {

    _1("1", "销方失信"),
    _2("2", "敏感词"),
    _3("3", "购方信息不一致"),
    _4("4", "发票状态异常"),
    _5("5", "退回"),
    _6("6", "数据源不一致");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ComplianceContentEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ComplianceContentEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
