package com.xforceplus.ultraman.app.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红冲状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-21
 */
public enum RedStatusEnum {

    _0("0", "默认"),
    _1("1", "待红冲"),
    _2("2", "待部分红冲"),
    _3("3", "红冲"),
    _4("4", "部分红冲");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
