package com.xforceplus.ultraman.app.jccqyy.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 红字信息
 * </p>
 *
 * @author ultraman
 * @since 2022-10-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RedLetter implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 原始单据金额
   */
  @TableField("originAmount")
  private String originAmount;

  /**
   * 原蓝票开票日期
   */
  @TableField("originDateIssued")
  private String originDateIssued;

  /**
   * 原始发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 原始发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 红字信息编号
   */
  @TableField("redLetterNumber")
  private String redLetterNumber;

  /**
   * 红冲时间
   */
  @TableField("reverseTime")
  private String reverseTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("originAmount", originAmount);
      map.put("originDateIssued", originDateIssued);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceType", originInvoiceType);
      map.put("redLetterNumber", redLetterNumber);
      map.put("reverseTime", reverseTime);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static RedLetter fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RedLetter entity = new RedLetter();
    if(map.containsKey("originAmount")) {
      Object obj = map.get("originAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originDateIssued")) {
      Object obj = map.get("originDateIssued");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReverseTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("originAmount")) {
      Object obj = map.get("originAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originDateIssued")) {
      Object obj = map.get("originDateIssued");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginDateIssued((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedLetterNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReverseTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
