package com.xforceplus.ultraman.app.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 所属业务系统
 * </p>
 *
 * @author ultraman
 * @since 2022-11-24
 */
public enum IncaSystemCodeEnum {

    _10051("10051", "英克零售"),
    _10061("10061", "英克批发");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IncaSystemCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IncaSystemCodeEnum fromCode(String code){
        switch(code) {
            case "10051":
                return _10051;
            case "10061":
                return _10061;
            default:
                return null;
        }
    }
}
