package com.xforceplus.ultraman.app.jccqyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 税改标识枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-11-24
 */
public enum TaxReformFlagEnum {

    _0("0", "默认"),
    _1("1", "国税2.0");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxReformFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxReformFlagEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
