package com.xforceplus.ultraman.app.jccqyy.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 进项发票明细信息
 * </p>
 *
 * @author ultraman
 * @since 2022-11-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaserInvoiceItem implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票主表ID
   */
  @TableField("invoiceId")
  private Long invoiceId;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 货物或应税劳务代码
   */
  @TableField("cargoCode")
  private String cargoCode;

  /**
   * 货物或应税劳务名称
   */
  @TableField("cargoName")
  private String cargoName;

  /**
   * 规格型号
   */
  @TableField("itemSpec")
  private String itemSpec;

  /**
   * 商品单位
   */
  @TableField("quantityUnit")
  private String quantityUnit;

  /**
   * 商品数量
   */
  private BigDecimal quantity;

  /**
   * 商品税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 不含税单价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税折扣金额
   */
  @TableField("discountWithoutTax")
  private BigDecimal discountWithoutTax;

  /**
   * 折扣率
   */
  @TableField("discountRate")
  private BigDecimal discountRate;

  /**
   * 商品税目
   */
  @TableField("taxItem")
  private String taxItem;

  /**
   * 税编版本号
   */
  @TableField("goodsNoVer")
  private String goodsNoVer;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 商品编号(ERP)   根据税编+品规去匹配，默认取第一个
   */
  @TableField("goodsErpNo")
  private String goodsErpNo;

  /**
   * 车牌号
   */
  @TableField("plateNumber")
  private String plateNumber;

  /**
   * 车辆类型
   */
  @TableField("vehicleType")
  private String vehicleType;

  /**
   * 通行日期起
   */
  @TableField("tollStartDate")
  private String tollStartDate;

  /**
   * 通行日期止
   */
  @TableField("tollEndDate")
  private String tollEndDate;

  /**
   * 不合规批次号
   */
  @TableField("complianceBatchId")
  private Long complianceBatchId;

  /**
   * 合规状态
   */
  @TableField("complianceStatus")
  private String complianceStatus;

  /**
   * 税收优惠政策
   */
  @TableField("taxPreFlag")
  private String taxPreFlag;

  /**
   * 享受税收优惠政策内容
   */
  @TableField("taxPreContent")
  private String taxPreContent;

  /**
   * 零税率标志
   */
  @TableField("taxRateType")
  private String taxRateType;

  /**
   * 扣除额
   */
  @TableField("taxDedunction")
  private BigDecimal taxDedunction;

  /**
   * 折扣行标志
   */
  @TableField("discountFlag")
  private String discountFlag;

  /**
   * 价格方式  0-默认
   */
  @TableField("priceMethod")
  private String priceMethod;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceId", invoiceId);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("cargoCode", cargoCode);
      map.put("cargoName", cargoName);
      map.put("itemSpec", itemSpec);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("taxRate", taxRate);
      map.put("unitPrice", unitPrice);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("discountWithoutTax", discountWithoutTax);
      map.put("discountRate", discountRate);
      map.put("taxItem", taxItem);
      map.put("goodsNoVer", goodsNoVer);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("goodsErpNo", goodsErpNo);
      map.put("plateNumber", plateNumber);
      map.put("vehicleType", vehicleType);
      map.put("tollStartDate", tollStartDate);
      map.put("tollEndDate", tollEndDate);
      map.put("complianceBatchId", complianceBatchId);
      map.put("complianceStatus", complianceStatus);
      map.put("taxPreFlag", taxPreFlag);
      map.put("taxPreContent", taxPreContent);
      map.put("taxRateType", taxRateType);
      map.put("taxDedunction", taxDedunction);
      map.put("discountFlag", discountFlag);
      map.put("priceMethod", priceMethod);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static PurchaserInvoiceItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaserInvoiceItem entity = new PurchaserInvoiceItem();
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoCode")) {
      Object obj = map.get("cargoCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCargoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountWithoutTax")) {
      Object obj = map.get("discountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxItem")) {
      Object obj = map.get("taxItem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsNoVer")) {
      Object obj = map.get("goodsNoVer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsNoVer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsErpNo")) {
      Object obj = map.get("goodsErpNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsErpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plateNumber")) {
      Object obj = map.get("plateNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlateNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleType")) {
      Object obj = map.get("vehicleType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tollStartDate")) {
      Object obj = map.get("tollStartDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTollStartDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tollEndDate")) {
      Object obj = map.get("tollEndDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTollEndDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complianceBatchId")) {
      Object obj = map.get("complianceBatchId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setComplianceBatchId((Long)obj);
        } else if(obj instanceof String) {
          entity.setComplianceBatchId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setComplianceBatchId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("complianceStatus")) {
      Object obj = map.get("complianceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreFlag")) {
      Object obj = map.get("taxPreFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreContent")) {
      Object obj = map.get("taxPreContent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRateType")) {
      Object obj = map.get("taxRateType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDedunction")) {
      Object obj = map.get("taxDedunction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxDedunction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxDedunction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxDedunction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxDedunction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxDedunction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountFlag")) {
      Object obj = map.get("discountFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          this.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cargoCode")) {
      Object obj = map.get("cargoCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCargoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCargoName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountWithoutTax")) {
      Object obj = map.get("discountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxItem")) {
      Object obj = map.get("taxItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsNoVer")) {
      Object obj = map.get("goodsNoVer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsNoVer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsErpNo")) {
      Object obj = map.get("goodsErpNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsErpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("plateNumber")) {
      Object obj = map.get("plateNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlateNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicleType")) {
      Object obj = map.get("vehicleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tollStartDate")) {
      Object obj = map.get("tollStartDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTollStartDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tollEndDate")) {
      Object obj = map.get("tollEndDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTollEndDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("complianceBatchId")) {
      Object obj = map.get("complianceBatchId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setComplianceBatchId((Long)obj);
        } else if(obj instanceof String) {
          this.setComplianceBatchId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setComplianceBatchId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("complianceStatus")) {
      Object obj = map.get("complianceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setComplianceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPreFlag")) {
      Object obj = map.get("taxPreFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPreContent")) {
      Object obj = map.get("taxPreContent");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRateType")) {
      Object obj = map.get("taxRateType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxDedunction")) {
      Object obj = map.get("taxDedunction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxDedunction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxDedunction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxDedunction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxDedunction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxDedunction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountFlag")) {
      Object obj = map.get("discountFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriceMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
