package com.xforceplus.ultraman.app.jccqyy.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 进项发票主表信息
 * </p>
 *
 * @author ultraman
 * @since 2022-11-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaserInvoiceMain implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 发票状态
   */
  private String status;

  /**
   * 开票日期
   */
  @TableField("paperDrewDate")
  private String paperDrewDate;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方纳税人识别号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方纳税人识别号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 机器编码
   */
  @TableField("machineCode")
  private String machineCode;

  /**
   * 校验码
   */
  @TableField("checkCode")
  private String checkCode;

  /**
   * 密文
   */
  @TableField("cipherText")
  private String cipherText;

  /**
   * 收款人姓名
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人姓名
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 发票来源
   */
  @TableField("invoiceOrig")
  private String invoiceOrig;

  /**
   * 业务单ID
   */
  @TableField("bussinessId")
  private Long bussinessId;

  /**
   * 业务单号
   */
  @TableField("bussinessNo")
  private String bussinessNo;

  /**
   * 集团分组标记
   */
  @TableField("groupFlag")
  private String groupFlag;

  /**
   * 购方集团ID（票易通）
   */
  @TableField("purchaserGroupId")
  private Long purchaserGroupId;

  /**
   * 购方公司ID（票易通）
   */
  @TableField("purchaserCompanyId")
  private Long purchaserCompanyId;

  /**
   * 购方组织ID（票易通）
   */
  @TableField("purchaserOrgId")
  private Long purchaserOrgId;

  /**
   * 购方公司编号（外部系统）
   */
  @TableField("purchaserExternalCode")
  private String purchaserExternalCode;

  /**
   * 购方租户公司编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 销方集团ID（票易通）
   */
  @TableField("sellerGroupId")
  private Long sellerGroupId;

  /**
   * 销方公司ID（票易通）
   */
  @TableField("sellerCompanyId")
  private Long sellerCompanyId;

  /**
   * 销方组织ID（票易通）
   */
  @TableField("sellerOrgId")
  private Long sellerOrgId;

  /**
   * 销方客商组织ID
   */
  @TableField("sellerSupplierOrgId")
  private Long sellerSupplierOrgId;

  /**
   * 销方公司编号（外部系统）
   */
  @TableField("sellerExternalCode")
  private String sellerExternalCode;

  /**
   * 销方租户公司编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方发票主表ID
   */
  @TableField("sellerInvoiceId")
  private Long sellerInvoiceId;

  /**
   * 销方开具状态
   */
  @TableField("sellerSyncStatus")
  private String sellerSyncStatus;

  /**
   * 协同来源
   */
  @TableField("sellerOrigin")
  private String sellerOrigin;

  /**
   * 红冲状态
   */
  @TableField("redStatus")
  private String redStatus;

  /**
   * 红冲时间
   */
  @TableField("redTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redTime;

  /**
   * 红字信息表编号
   */
  @TableField("redNotificationNo")
  private String redNotificationNo;

  /**
   * 识别状态
   */
  @TableField("recogStatus")
  private String recogStatus;

  /**
   * 识别影像状态
   */
  @TableField("recogImageStatus")
  private String recogImageStatus;

  /**
   * 识别发票主表ID
   */
  @TableField("recogInvoiceId")
  private Long recogInvoiceId;

  /**
   * 识别操作人姓名
   */
  @TableField("recogUserName")
  private String recogUserName;

  /**
   * 识别影像抵扣联路径
   */
  @TableField("recogDeductionImageUrl")
  private String recogDeductionImageUrl;

  /**
   * 识别影像发票联路径
   */
  @TableField("recogInvoiceImageUrl")
  private String recogInvoiceImageUrl;

  /**
   * 识别完成时间
   */
  @TableField("recogResponseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recogResponseTime;

  /**
   * PDF文件地址
   */
  @TableField("pdfUrl")
  private String pdfUrl;

  /**
   * 源文件类型
   */
  @TableField("originFile")
  private String originFile;

  /**
   * 国税验真主表ID
   */
  @TableField("veriInvoiceId")
  private Long veriInvoiceId;

  /**
   * 查验状态
   */
  @TableField("veriStatus")
  private String veriStatus;

  /**
   * 验真备注
   */
  @TableField("veriRemark")
  private String veriRemark;

  /**
   * 验签状态
   */
  private String validate;

  /**
   * 查验发送时间
   */
  @TableField("veriRequestTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriRequestTime;

  /**
   * 查验完成时间
   */
  @TableField("veriResponseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime veriResponseTime;

  /**
   * 查验操作人姓名
   */
  @TableField("veriUserName")
  private String veriUserName;

  /**
   * 国税底账主表ID
   */
  @TableField("taxInvoiceId")
  private Long taxInvoiceId;

  /**
   * 电子底账状态
   */
  @TableField("authSyncStatus")
  private String authSyncStatus;

  /**
   * 电子底帐获取时间
   */
  @TableField("authSyncTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authSyncTime;

  /**
   * 认证状态
   */
  @TableField("authStatus")
  private String authStatus;

  /**
   * 是否满足认证条件
   */
  @TableField("authSatisfyStatus")
  private String authSatisfyStatus;

  /**
   * 认证方式
   */
  @TableField("authStyle")
  private String authStyle;

  /**
   * 认证业务日期
   */
  @TableField("authBussiDate")
  private String authBussiDate;

  /**
   * 认证所属期
   */
  @TableField("authTaxPeriod")
  private String authTaxPeriod;

  /**
   * 认证发送时间
   */
  @TableField("authRequestTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authRequestTime;

  /**
   * 认证完成时间
   */
  @TableField("authResponseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authResponseTime;

  /**
   * 认证操作人姓名
   */
  @TableField("authRequestUserName")
  private String authRequestUserName;

  /**
   * 合规状态
   */
  @TableField("complianceStatus")
  private String complianceStatus;

  /**
   * 不合规批次号
   */
  @TableField("complianceBatchId")
  private Long complianceBatchId;

  /**
   * 特殊发票标记
   */
  @TableField("specialInvoiceFlag")
  private String specialInvoiceFlag;

  /**
   * 抬头是否有误
   */
  @TableField("titleOkFlag")
  private String titleOkFlag;

  /**
   * 是否有销货清单
   */
  @TableField("saleListFlag")
  private String saleListFlag;

  /**
   * 数据源比对是否一致
   */
  @TableField("dataOkFlag")
  private String dataOkFlag;

  /**
   * 红蓝标识
   */
  @TableField("invoiceColor")
  private String invoiceColor;

  /**
   * 退票状态
   */
  @TableField("retreatStatus")
  private String retreatStatus;

  /**
   * 退票备注
   */
  @TableField("retreatRemark")
  private String retreatRemark;

  /**
   * 销方查看影像标志
   */
  @TableField("sellerViewImageFlag")
  private String sellerViewImageFlag;

  /**
   * 发票匹配状态
   */
  @TableField("matchStatus")
  private String matchStatus;

  /**
   * 匹配金额(含税金额)
   */
  @TableField("matchAmount")
  private BigDecimal matchAmount;

  /**
   * 发票匹配操作时间
   */
  @TableField("matchTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime matchTime;

  /**
   * 记账状态
   */
  @TableField("chargeUpStatus")
  private String chargeUpStatus;

  /**
   * 记账单号
   */
  @TableField("chargeUpNo")
  private String chargeUpNo;

  /**
   * 记账金额
   */
  @TableField("chargeUpAmount")
  private BigDecimal chargeUpAmount;

  /**
   * 记账所属期
   */
  @TableField("chargeUpPeriod")
  private String chargeUpPeriod;

  /**
   * 记账人
   */
  @TableField("chargeUpPerson")
  private String chargeUpPerson;

  /**
   * 报账状态
   */
  @TableField("reportStatus")
  private String reportStatus;

  /**
   * 报账单号
   */
  @TableField("reportNo")
  private String reportNo;

  /**
   * 报账时间
   */
  @TableField("reportTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reportTime;

  /**
   * 核销状态
   */
  @TableField("saleConfirmStatus")
  private String saleConfirmStatus;

  /**
   * 核销单号
   */
  @TableField("saleConfirmNo")
  private String saleConfirmNo;

  /**
   * 核销所属期
   */
  @TableField("saleConfirmPeriod")
  private String saleConfirmPeriod;

  /**
   * 付款金额
   */
  @TableField("paymentAmount")
  private BigDecimal paymentAmount;

  /**
   * 付款状态
   */
  @TableField("paymentStatus")
  private String paymentStatus;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * 付款日期
   */
  @TableField("paymentDate")
  private String paymentDate;

  /**
   * 付款时间
   */
  @TableField("paymentTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentTime;

  /**
   * 付款批次号
   */
  @TableField("paymentBatchNo")
  private String paymentBatchNo;

  /**
   * 付款操作人姓名
   */
  @TableField("paymentUserName")
  private String paymentUserName;

  /**
   * 报销状态
   */
  @TableField("reimbursementStatus")
  private String reimbursementStatus;

  /**
   * 冻结状态
   */
  @TableField("freezeStatus")
  private String freezeStatus;

  /**
   * 遗失状态
   */
  @TableField("loseStatus")
  private String loseStatus;

  /**
   * 失信状态
   */
  @TableField("blackStatus")
  private String blackStatus;

  /**
   * 失信原因
   */
  @TableField("blackRemark")
  private String blackRemark;

  /**
   * 预警处理状态
   */
  @TableField("warnHandleStatus")
  private String warnHandleStatus;

  /**
   * 预警处理备注
   */
  @TableField("warnHandleRemark")
  private String warnHandleRemark;

  /**
   * 敏感词
   */
  @TableField("senseWord")
  private String senseWord;

  /**
   * 敏感词控制等级
   */
  @TableField("senseWordLevel")
  private String senseWordLevel;

  /**
   * 购方信息异常原因
   */
  @TableField("purCompanyExceptionContent")
  private String purCompanyExceptionContent;

  /**
   * 票面信息异常备注
   */
  @TableField("customRemark")
  private String customRemark;

  /**
   * 不合规内容
   */
  @TableField("complianceContent")
  private String complianceContent;

  /**
   * 预警时间
   */
  @TableField("warnTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime warnTime;

  /**
   * 挂起状态
   */
  @TableField("hangStatus")
  private String hangStatus;

  /**
   * 挂起原因
   */
  @TableField("hangRemark")
  private String hangRemark;

  /**
   * 税改标识
   */
  @TableField("taxReformFlag")
  private String taxReformFlag;

  /**
   * 勾选时间
   */
  @TableField("checkTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  /**
   * 有效税额
   */
  @TableField("effectiveTaxAmount")
  private BigDecimal effectiveTaxAmount;

  /**
   * 抵扣用途
   */
  @TableField("authUse")
  private String authUse;

  /**
   * 认证备注
   */
  @TableField("authRemark")
  private String authRemark;

  /**
   * 进转出状态
   */
  @TableField("turnOutStatus")
  private String turnOutStatus;

  /**
   * 进转出类型
   */
  @TableField("turnOutType")
  private String turnOutType;

  /**
   * 进转出金额
   */
  @TableField("turnOutAmount")
  private BigDecimal turnOutAmount;

  /**
   * 进转出所属期
   */
  @TableField("turnOutPeriod")
  private String turnOutPeriod;

  /**
   * 进转出备注
   */
  @TableField("turnOutRemark")
  private String turnOutRemark;

  /**
   * 客户数据编号
   */
  @TableField("customerNo")
  private String customerNo;

  /**
   * 业务标签判断
   */
  @TableField("businessTag")
  private String businessTag;

  /**
   * 审核状态
   */
  @TableField("auditStatus")
  private String auditStatus;

  /**
   * 审核人
   */
  @TableField("auditName")
  private String auditName;

  /**
   * 审核时间
   */
  @TableField("auditTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;

  /**
   * 签收状态
   */
  @TableField("signForStatus")
  private String signForStatus;

  /**
   * 签收日期
   */
  @TableField("signForPeriod")
  private String signForPeriod;

  /**
   * 签收时间
   */
  @TableField("signForTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signForTime;

  /**
   * 发送状态
   */
  @TableField("sendStatus")
  private String sendStatus;

  /**
   * 发送备注
   */
  @TableField("sendRemark")
  private String sendRemark;

  /**
   * 代开标记
   */
  @TableField("issueFlag")
  private String issueFlag;

  /**
   * 代开名称
   */
  @TableField("issueName")
  private String issueName;

  /**
   * 代开纳税人识别号
   */
  @TableField("issueTaxNo")
  private String issueTaxNo;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方地址电话
   */
  @TableField("purchaserAddrTel")
  private String purchaserAddrTel;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 购方银行名称账号
   */
  @TableField("purchaserBankNameAccount")
  private String purchaserBankNameAccount;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddrTel")
  private String sellerAddrTel;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 销方银行名称账号
   */
  @TableField("sellerBankNameAccount")
  private String sellerBankNameAccount;

  /**
   * 部门名称
   */
  @TableField("sectionName")
  private String sectionName;

  /**
   * 发票备注
   */
  private String remark;

  /**
   * 拓展字段1
   */
  private String ext1;

  /**
   * 拓展字段2
   */
  private String ext2;

  /**
   * 拓展字段3
   */
  private String ext3;

  /**
   * 拓展字段4
   */
  private String ext4;

  /**
   * 拓展字段5
   */
  private String ext5;

  /**
   * 拓展字段6
   */
  private String ext6;

  /**
   * 拓展字段7
   */
  private String ext7;

  /**
   * 拓展字段8
   */
  private String ext8;

  /**
   * 拓展字段9
   */
  private String ext9;

  /**
   * 拓展字段10
   */
  private String ext10;

  /**
   * 拓展字段11
   */
  private String ext11;

  /**
   * 拓展字段12
   */
  private String ext12;

  /**
   * 拓展字段13
   */
  private String ext13;

  /**
   * 拓展字段14
   */
  private String ext14;

  /**
   * 拓展字段15
   */
  private String ext15;

  /**
   * 拓展字段16
   */
  private String ext16;

  /**
   * 拓展字段17
   */
  private String ext17;

  /**
   * 拓展字段18
   */
  private String ext18;

  /**
   * 拓展字段19
   */
  private String ext19;

  /**
   * 拓展字段20
   */
  private String ext20;

  /**
   * 拓展字段21
   */
  private String ext21;

  /**
   * 拓展字段22
   */
  private String ext22;

  /**
   * 拓展字段23
   */
  private String ext23;

  /**
   * 拓展字段24
   */
  private String ext24;

  /**
   * 拓展字段25
   */
  private String ext25;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceType", invoiceType);
      map.put("status", status);
      map.put("paperDrewDate", paperDrewDate);
      map.put("taxRate", taxRate);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("machineCode", machineCode);
      map.put("checkCode", checkCode);
      map.put("cipherText", cipherText);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("invoiceOrig", invoiceOrig);
      map.put("bussinessId", bussinessId);
      map.put("bussinessNo", bussinessNo);
      map.put("groupFlag", groupFlag);
      map.put("purchaserGroupId", purchaserGroupId);
      map.put("purchaserCompanyId", purchaserCompanyId);
      map.put("purchaserOrgId", purchaserOrgId);
      map.put("purchaserExternalCode", purchaserExternalCode);
      map.put("purchaserNo", purchaserNo);
      map.put("sellerGroupId", sellerGroupId);
      map.put("sellerCompanyId", sellerCompanyId);
      map.put("sellerOrgId", sellerOrgId);
      map.put("sellerSupplierOrgId", sellerSupplierOrgId);
      map.put("sellerExternalCode", sellerExternalCode);
      map.put("sellerNo", sellerNo);
      map.put("sellerInvoiceId", sellerInvoiceId);
      map.put("sellerSyncStatus", sellerSyncStatus);
      map.put("sellerOrigin", sellerOrigin);
      map.put("redStatus", redStatus);
      map.put("redTime", BocpGenUtils.toTimestamp(redTime));
      map.put("redNotificationNo", redNotificationNo);
      map.put("recogStatus", recogStatus);
      map.put("recogImageStatus", recogImageStatus);
      map.put("recogInvoiceId", recogInvoiceId);
      map.put("recogUserName", recogUserName);
      map.put("recogDeductionImageUrl", recogDeductionImageUrl);
      map.put("recogInvoiceImageUrl", recogInvoiceImageUrl);
      map.put("recogResponseTime", BocpGenUtils.toTimestamp(recogResponseTime));
      map.put("pdfUrl", pdfUrl);
      map.put("originFile", originFile);
      map.put("veriInvoiceId", veriInvoiceId);
      map.put("veriStatus", veriStatus);
      map.put("veriRemark", veriRemark);
      map.put("validate", validate);
      map.put("veriRequestTime", BocpGenUtils.toTimestamp(veriRequestTime));
      map.put("veriResponseTime", BocpGenUtils.toTimestamp(veriResponseTime));
      map.put("veriUserName", veriUserName);
      map.put("taxInvoiceId", taxInvoiceId);
      map.put("authSyncStatus", authSyncStatus);
      map.put("authSyncTime", BocpGenUtils.toTimestamp(authSyncTime));
      map.put("authStatus", authStatus);
      map.put("authSatisfyStatus", authSatisfyStatus);
      map.put("authStyle", authStyle);
      map.put("authBussiDate", authBussiDate);
      map.put("authTaxPeriod", authTaxPeriod);
      map.put("authRequestTime", BocpGenUtils.toTimestamp(authRequestTime));
      map.put("authResponseTime", BocpGenUtils.toTimestamp(authResponseTime));
      map.put("authRequestUserName", authRequestUserName);
      map.put("complianceStatus", complianceStatus);
      map.put("complianceBatchId", complianceBatchId);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      map.put("titleOkFlag", titleOkFlag);
      map.put("saleListFlag", saleListFlag);
      map.put("dataOkFlag", dataOkFlag);
      map.put("invoiceColor", invoiceColor);
      map.put("retreatStatus", retreatStatus);
      map.put("retreatRemark", retreatRemark);
      map.put("sellerViewImageFlag", sellerViewImageFlag);
      map.put("matchStatus", matchStatus);
      map.put("matchAmount", matchAmount);
      map.put("matchTime", BocpGenUtils.toTimestamp(matchTime));
      map.put("chargeUpStatus", chargeUpStatus);
      map.put("chargeUpNo", chargeUpNo);
      map.put("chargeUpAmount", chargeUpAmount);
      map.put("chargeUpPeriod", chargeUpPeriod);
      map.put("chargeUpPerson", chargeUpPerson);
      map.put("reportStatus", reportStatus);
      map.put("reportNo", reportNo);
      map.put("reportTime", BocpGenUtils.toTimestamp(reportTime));
      map.put("saleConfirmStatus", saleConfirmStatus);
      map.put("saleConfirmNo", saleConfirmNo);
      map.put("saleConfirmPeriod", saleConfirmPeriod);
      map.put("paymentAmount", paymentAmount);
      map.put("paymentStatus", paymentStatus);
      map.put("paymentNo", paymentNo);
      map.put("paymentDate", paymentDate);
      map.put("paymentTime", BocpGenUtils.toTimestamp(paymentTime));
      map.put("paymentBatchNo", paymentBatchNo);
      map.put("paymentUserName", paymentUserName);
      map.put("reimbursementStatus", reimbursementStatus);
      map.put("freezeStatus", freezeStatus);
      map.put("loseStatus", loseStatus);
      map.put("blackStatus", blackStatus);
      map.put("blackRemark", blackRemark);
      map.put("warnHandleStatus", warnHandleStatus);
      map.put("warnHandleRemark", warnHandleRemark);
      map.put("senseWord", senseWord);
      map.put("senseWordLevel", senseWordLevel);
      map.put("purCompanyExceptionContent", purCompanyExceptionContent);
      map.put("customRemark", customRemark);
      map.put("complianceContent", complianceContent);
      map.put("warnTime", BocpGenUtils.toTimestamp(warnTime));
      map.put("hangStatus", hangStatus);
      map.put("hangRemark", hangRemark);
      map.put("taxReformFlag", taxReformFlag);
      map.put("checkTime", BocpGenUtils.toTimestamp(checkTime));
      map.put("effectiveTaxAmount", effectiveTaxAmount);
      map.put("authUse", authUse);
      map.put("authRemark", authRemark);
      map.put("turnOutStatus", turnOutStatus);
      map.put("turnOutType", turnOutType);
      map.put("turnOutAmount", turnOutAmount);
      map.put("turnOutPeriod", turnOutPeriod);
      map.put("turnOutRemark", turnOutRemark);
      map.put("customerNo", customerNo);
      map.put("businessTag", businessTag);
      map.put("auditStatus", auditStatus);
      map.put("auditName", auditName);
      map.put("auditTime", BocpGenUtils.toTimestamp(auditTime));
      map.put("signForStatus", signForStatus);
      map.put("signForPeriod", signForPeriod);
      map.put("signForTime", BocpGenUtils.toTimestamp(signForTime));
      map.put("sendStatus", sendStatus);
      map.put("sendRemark", sendRemark);
      map.put("issueFlag", issueFlag);
      map.put("issueName", issueName);
      map.put("issueTaxNo", issueTaxNo);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("purchaserBankNameAccount", purchaserBankNameAccount);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerBankNameAccount", sellerBankNameAccount);
      map.put("sectionName", sectionName);
      map.put("remark", remark);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      return map;
  }

  public static PurchaserInvoiceMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaserInvoiceMain entity = new PurchaserInvoiceMain();
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussinessId")) {
      Object obj = map.get("bussinessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBussinessId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBussinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBussinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bussinessNo")) {
      Object obj = map.get("bussinessNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBussinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groupFlag")) {
      Object obj = map.get("groupFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGroupFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserCompanyId")) {
      Object obj = map.get("purchaserCompanyId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserOrgId")) {
      Object obj = map.get("purchaserOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserExternalCode")) {
      Object obj = map.get("purchaserExternalCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserExternalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyId")) {
      Object obj = map.get("sellerCompanyId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerOrgId")) {
      Object obj = map.get("sellerOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerSupplierOrgId")) {
      Object obj = map.get("sellerSupplierOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerSupplierOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerSupplierOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerSupplierOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerExternalCode")) {
      Object obj = map.get("sellerExternalCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerExternalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerInvoiceId")) {
      Object obj = map.get("sellerInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerSyncStatus")) {
      Object obj = map.get("sellerSyncStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerOrigin")) {
      Object obj = map.get("sellerOrigin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedTime(null);
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogStatus")) {
      Object obj = map.get("recogStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogImageStatus")) {
      Object obj = map.get("recogImageStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogImageStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogInvoiceId")) {
      Object obj = map.get("recogInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setRecogInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecogInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recogUserName")) {
      Object obj = map.get("recogUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogDeductionImageUrl")) {
      Object obj = map.get("recogDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogInvoiceImageUrl")) {
      Object obj = map.get("recogInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogResponseTime")) {
      Object obj = map.get("recogResponseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRecogResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRecogResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecogResponseTime(null);
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originFile")) {
      Object obj = map.get("originFile");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriInvoiceId")) {
      Object obj = map.get("veriInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVeriInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVeriInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriRemark")) {
      Object obj = map.get("veriRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validate")) {
      Object obj = map.get("validate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setValidate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriRequestTime")) {
      Object obj = map.get("veriRequestTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setVeriRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriRequestTime(null);
      }
    }
    if(map.containsKey("veriResponseTime")) {
      Object obj = map.get("veriResponseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setVeriResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVeriResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVeriResponseTime(null);
      }
    }
    if(map.containsKey("veriUserName")) {
      Object obj = map.get("veriUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceId")) {
      Object obj = map.get("taxInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTaxInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("authSyncStatus")) {
      Object obj = map.get("authSyncStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSyncTime")) {
      Object obj = map.get("authSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthSyncTime(null);
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSatisfyStatus")) {
      Object obj = map.get("authSatisfyStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthSatisfyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStyle")) {
      Object obj = map.get("authStyle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authBussiDate")) {
      Object obj = map.get("authBussiDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthBussiDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authTaxPeriod")) {
      Object obj = map.get("authTaxPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRequestTime")) {
      Object obj = map.get("authRequestTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthRequestTime(null);
      }
    }
    if(map.containsKey("authResponseTime")) {
      Object obj = map.get("authResponseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthResponseTime(null);
      }
    }
    if(map.containsKey("authRequestUserName")) {
      Object obj = map.get("authRequestUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthRequestUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complianceStatus")) {
      Object obj = map.get("complianceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complianceBatchId")) {
      Object obj = map.get("complianceBatchId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setComplianceBatchId((Long)obj);
        } else if(obj instanceof String) {
          entity.setComplianceBatchId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setComplianceBatchId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("titleOkFlag")) {
      Object obj = map.get("titleOkFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTitleOkFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFlag")) {
      Object obj = map.get("saleListFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleListFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataOkFlag")) {
      Object obj = map.get("dataOkFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataOkFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatRemark")) {
      Object obj = map.get("retreatRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerViewImageFlag")) {
      Object obj = map.get("sellerViewImageFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerViewImageFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchAmount")) {
      Object obj = map.get("matchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("matchTime")) {
      Object obj = map.get("matchTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMatchTime(null);
      }
    }
    if(map.containsKey("chargeUpStatus")) {
      Object obj = map.get("chargeUpStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpNo")) {
      Object obj = map.get("chargeUpNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpAmount")) {
      Object obj = map.get("chargeUpAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeUpAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChargeUpAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeUpAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpPeriod")) {
      Object obj = map.get("chargeUpPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpPerson")) {
      Object obj = map.get("chargeUpPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reportStatus")) {
      Object obj = map.get("reportStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReportStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reportNo")) {
      Object obj = map.get("reportNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReportNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reportTime")) {
      Object obj = map.get("reportTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReportTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReportTime(null);
      }
    }
    if(map.containsKey("saleConfirmStatus")) {
      Object obj = map.get("saleConfirmStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleConfirmNo")) {
      Object obj = map.get("saleConfirmNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleConfirmNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleConfirmPeriod")) {
      Object obj = map.get("saleConfirmPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleConfirmPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentAmount")) {
      Object obj = map.get("paymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTime")) {
      Object obj = map.get("paymentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentTime(null);
      }
    }
    if(map.containsKey("paymentBatchNo")) {
      Object obj = map.get("paymentBatchNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUserName")) {
      Object obj = map.get("paymentUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursementStatus")) {
      Object obj = map.get("reimbursementStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReimbursementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeStatus")) {
      Object obj = map.get("freezeStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreezeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("loseStatus")) {
      Object obj = map.get("loseStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("blackStatus")) {
      Object obj = map.get("blackStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBlackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("blackRemark")) {
      Object obj = map.get("blackRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBlackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warnHandleStatus")) {
      Object obj = map.get("warnHandleStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarnHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warnHandleRemark")) {
      Object obj = map.get("warnHandleRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarnHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("senseWord")) {
      Object obj = map.get("senseWord");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSenseWord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("senseWordLevel")) {
      Object obj = map.get("senseWordLevel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSenseWordLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purCompanyExceptionContent")) {
      Object obj = map.get("purCompanyExceptionContent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurCompanyExceptionContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customRemark")) {
      Object obj = map.get("customRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complianceContent")) {
      Object obj = map.get("complianceContent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComplianceContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warnTime")) {
      Object obj = map.get("warnTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarnTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setWarnTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setWarnTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setWarnTime(null);
      }
    }
    if(map.containsKey("hangStatus")) {
      Object obj = map.get("hangStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hangRemark")) {
      Object obj = map.get("hangRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxReformFlag")) {
      Object obj = map.get("taxReformFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxReformFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkTime")) {
      Object obj = map.get("checkTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("effectiveTaxAmount")) {
      Object obj = map.get("effectiveTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("authUse")) {
      Object obj = map.get("authUse");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRemark")) {
      Object obj = map.get("authRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutStatus")) {
      Object obj = map.get("turnOutStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutType")) {
      Object obj = map.get("turnOutType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutAmount")) {
      Object obj = map.get("turnOutAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTurnOutAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTurnOutAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTurnOutAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTurnOutAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTurnOutAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("turnOutPeriod")) {
      Object obj = map.get("turnOutPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutRemark")) {
      Object obj = map.get("turnOutRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTag")) {
      Object obj = map.get("businessTag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditName")) {
      Object obj = map.get("auditName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditTime")) {
      Object obj = map.get("auditTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("signForStatus")) {
      Object obj = map.get("signForStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signForPeriod")) {
      Object obj = map.get("signForPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignForPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signForTime")) {
      Object obj = map.get("signForTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignForTime(null);
      }
    }
    if(map.containsKey("sendStatus")) {
      Object obj = map.get("sendStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSendStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendRemark")) {
      Object obj = map.get("sendRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSendRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issueFlag")) {
      Object obj = map.get("issueFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssueFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issueName")) {
      Object obj = map.get("issueName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssueName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issueTaxNo")) {
      Object obj = map.get("issueTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssueTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNameAccount")) {
      Object obj = map.get("purchaserBankNameAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNameAccount")) {
      Object obj = map.get("sellerBankNameAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionName")) {
      Object obj = map.get("sectionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSectionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaperDrewDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMachineCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bussinessId")) {
      Object obj = map.get("bussinessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBussinessId((Long)obj);
        } else if(obj instanceof String) {
          this.setBussinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBussinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("bussinessNo")) {
      Object obj = map.get("bussinessNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("groupFlag")) {
      Object obj = map.get("groupFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserCompanyId")) {
      Object obj = map.get("purchaserCompanyId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserCompanyId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserOrgId")) {
      Object obj = map.get("purchaserOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserExternalCode")) {
      Object obj = map.get("purchaserExternalCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserExternalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyId")) {
      Object obj = map.get("sellerCompanyId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerCompanyId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerOrgId")) {
      Object obj = map.get("sellerOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerSupplierOrgId")) {
      Object obj = map.get("sellerSupplierOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerSupplierOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerSupplierOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerSupplierOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerExternalCode")) {
      Object obj = map.get("sellerExternalCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerExternalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerInvoiceId")) {
      Object obj = map.get("sellerInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerSyncStatus")) {
      Object obj = map.get("sellerSyncStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerSyncStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerOrigin")) {
      Object obj = map.get("sellerOrigin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerOrigin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRedTime(null);
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recogStatus")) {
      Object obj = map.get("recogStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recogImageStatus")) {
      Object obj = map.get("recogImageStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogImageStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recogInvoiceId")) {
      Object obj = map.get("recogInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          this.setRecogInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRecogInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("recogUserName")) {
      Object obj = map.get("recogUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recogDeductionImageUrl")) {
      Object obj = map.get("recogDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogDeductionImageUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recogInvoiceImageUrl")) {
      Object obj = map.get("recogInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogInvoiceImageUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recogResponseTime")) {
      Object obj = map.get("recogResponseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRecogResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setRecogResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRecogResponseTime(null);
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originFile")) {
      Object obj = map.get("originFile");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginFile((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("veriInvoiceId")) {
      Object obj = map.get("veriInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVeriInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          this.setVeriInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVeriInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVeriStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("veriRemark")) {
      Object obj = map.get("veriRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVeriRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("validate")) {
      Object obj = map.get("validate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("veriRequestTime")) {
      Object obj = map.get("veriRequestTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVeriRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setVeriRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setVeriRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setVeriRequestTime(null);
      }
    }
    if(map.containsKey("veriResponseTime")) {
      Object obj = map.get("veriResponseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVeriResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setVeriResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setVeriResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setVeriResponseTime(null);
      }
    }
    if(map.containsKey("veriUserName")) {
      Object obj = map.get("veriUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVeriUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceId")) {
      Object obj = map.get("taxInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          this.setTaxInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("authSyncStatus")) {
      Object obj = map.get("authSyncStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthSyncStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authSyncTime")) {
      Object obj = map.get("authSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAuthSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthSyncTime(null);
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authSatisfyStatus")) {
      Object obj = map.get("authSatisfyStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthSatisfyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authStyle")) {
      Object obj = map.get("authStyle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStyle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authBussiDate")) {
      Object obj = map.get("authBussiDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthBussiDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authTaxPeriod")) {
      Object obj = map.get("authTaxPeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthTaxPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authRequestTime")) {
      Object obj = map.get("authRequestTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAuthRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthRequestTime(null);
      }
    }
    if(map.containsKey("authResponseTime")) {
      Object obj = map.get("authResponseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAuthResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthResponseTime(null);
      }
    }
    if(map.containsKey("authRequestUserName")) {
      Object obj = map.get("authRequestUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthRequestUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("complianceStatus")) {
      Object obj = map.get("complianceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setComplianceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("complianceBatchId")) {
      Object obj = map.get("complianceBatchId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setComplianceBatchId((Long)obj);
        } else if(obj instanceof String) {
          this.setComplianceBatchId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setComplianceBatchId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("titleOkFlag")) {
      Object obj = map.get("titleOkFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTitleOkFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saleListFlag")) {
      Object obj = map.get("saleListFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleListFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataOkFlag")) {
      Object obj = map.get("dataOkFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataOkFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreatRemark")) {
      Object obj = map.get("retreatRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerViewImageFlag")) {
      Object obj = map.get("sellerViewImageFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerViewImageFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matchAmount")) {
      Object obj = map.get("matchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("matchTime")) {
      Object obj = map.get("matchTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMatchTime(null);
      }
    }
    if(map.containsKey("chargeUpStatus")) {
      Object obj = map.get("chargeUpStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeUpNo")) {
      Object obj = map.get("chargeUpNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeUpAmount")) {
      Object obj = map.get("chargeUpAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setChargeUpAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setChargeUpAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setChargeUpAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setChargeUpAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setChargeUpAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("chargeUpPeriod")) {
      Object obj = map.get("chargeUpPeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeUpPerson")) {
      Object obj = map.get("chargeUpPerson");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reportStatus")) {
      Object obj = map.get("reportStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reportNo")) {
      Object obj = map.get("reportNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reportTime")) {
      Object obj = map.get("reportTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReportTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setReportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReportTime(null);
      }
    }
    if(map.containsKey("saleConfirmStatus")) {
      Object obj = map.get("saleConfirmStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saleConfirmNo")) {
      Object obj = map.get("saleConfirmNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saleConfirmPeriod")) {
      Object obj = map.get("saleConfirmPeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentAmount")) {
      Object obj = map.get("paymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentTime")) {
      Object obj = map.get("paymentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaymentTime(null);
      }
    }
    if(map.containsKey("paymentBatchNo")) {
      Object obj = map.get("paymentBatchNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentUserName")) {
      Object obj = map.get("paymentUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reimbursementStatus")) {
      Object obj = map.get("reimbursementStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReimbursementStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freezeStatus")) {
      Object obj = map.get("freezeStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFreezeStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("loseStatus")) {
      Object obj = map.get("loseStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLoseStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("blackStatus")) {
      Object obj = map.get("blackStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBlackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("blackRemark")) {
      Object obj = map.get("blackRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBlackRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warnHandleStatus")) {
      Object obj = map.get("warnHandleStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarnHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warnHandleRemark")) {
      Object obj = map.get("warnHandleRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarnHandleRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("senseWord")) {
      Object obj = map.get("senseWord");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSenseWord((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("senseWordLevel")) {
      Object obj = map.get("senseWordLevel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSenseWordLevel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purCompanyExceptionContent")) {
      Object obj = map.get("purCompanyExceptionContent");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurCompanyExceptionContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customRemark")) {
      Object obj = map.get("customRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("complianceContent")) {
      Object obj = map.get("complianceContent");
      if(obj != null) {
        if(obj instanceof String) {
          this.setComplianceContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warnTime")) {
      Object obj = map.get("warnTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWarnTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setWarnTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setWarnTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setWarnTime(null);
      }
    }
    if(map.containsKey("hangStatus")) {
      Object obj = map.get("hangStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hangRemark")) {
      Object obj = map.get("hangRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxReformFlag")) {
      Object obj = map.get("taxReformFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxReformFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkTime")) {
      Object obj = map.get("checkTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("effectiveTaxAmount")) {
      Object obj = map.get("effectiveTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("authUse")) {
      Object obj = map.get("authUse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthUse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authRemark")) {
      Object obj = map.get("authRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turnOutStatus")) {
      Object obj = map.get("turnOutStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turnOutType")) {
      Object obj = map.get("turnOutType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turnOutAmount")) {
      Object obj = map.get("turnOutAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTurnOutAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTurnOutAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTurnOutAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTurnOutAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTurnOutAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("turnOutPeriod")) {
      Object obj = map.get("turnOutPeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turnOutRemark")) {
      Object obj = map.get("turnOutRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessTag")) {
      Object obj = map.get("businessTag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditName")) {
      Object obj = map.get("auditName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditTime")) {
      Object obj = map.get("auditTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditTime(null);
      }
    }
    if(map.containsKey("signForStatus")) {
      Object obj = map.get("signForStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignForStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("signForPeriod")) {
      Object obj = map.get("signForPeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignForPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("signForTime")) {
      Object obj = map.get("signForTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSignForTime(null);
      }
    }
    if(map.containsKey("sendStatus")) {
      Object obj = map.get("sendStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sendRemark")) {
      Object obj = map.get("sendRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issueFlag")) {
      Object obj = map.get("issueFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssueFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issueName")) {
      Object obj = map.get("issueName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssueName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issueTaxNo")) {
      Object obj = map.get("issueTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssueTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankNameAccount")) {
      Object obj = map.get("purchaserBankNameAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankNameAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankNameAccount")) {
      Object obj = map.get("sellerBankNameAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankNameAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sectionName")) {
      Object obj = map.get("sectionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSectionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt21((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt22((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt23((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt24((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt25((String)obj);
        }
      } else {
      }
    }
  }
}
