package com.xforceplus.ultraman.app.jccqyy.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-20
 */
public enum CheckStatusEnum {

    _2("2", "验真成功"),
    _3("3", "验真失败"),
    _1("1", "验真中"),
    _0("0", "未验真");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckStatusEnum fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "3":
                return _3;
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
