package com.xforceplus.ultraman.app.jccqyy.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 源文件类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-20
 */
public enum OriginFileEnum {

    _0("0", "无源文件"),
    _1("1", "PDF"),
    _2("2", "OFD");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OriginFileEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OriginFileEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
