package com.xforceplus.ultraman.app.jccqyy.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 遗失状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-24
 */
public enum LoseStatusEnum {

    _0("0", "未遗失(默认)"),
    _1("1", "已遗失");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LoseStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LoseStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
