package com.xforceplus.ultraman.app.jccqyy.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 协同来源枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-10-24
 */
public enum SellerOriginEnum {

    _0("0", "默认"),
    _11("11", "销方直连"),
    _12("12", "销方抽取"),
    _13("13", "销方手工回填");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SellerOriginEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerOriginEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            default:
                return null;
        }
    }
}
