package com.xforceplus.ultraman.app.jccqyy.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-30
 */
public enum InvoiceType {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    CE("ce", "增值税电子普票发票"),
    SE("se", "增值税电子专用发票"),
    QC("qc", "电子发票（普通发票）"),
    QS("qs", "电子发票（增值税专用发票）"),
    CZ("cz", "纸质发票（普通发票）"),
    SZ("sz", "纸质发票（增值税专用发票）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "s":
                return S;
            case "ce":
                return CE;
            case "se":
                return SE;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            default:
                return null;
        }
    }
}
