package com.xforceplus.ultraman.app.jccqyy.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 购方信息异常原因枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-11-30
 */
public enum PurCompanyExceptionContentEnum {

    _1("1", "抬头不符"),
    _2("2", "地址电话不符"),
    _3("3", "银行信息不符");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PurCompanyExceptionContentEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurCompanyExceptionContentEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
