package com.xforceplus.ultraman.app.jccqyy.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 国税发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-11-30
 */
public enum TaxInvoiceSource {

    CE("ce", "全电发票"),
    QD("qd", "全电"),
    SK("sk", "税控");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxInvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSource fromCode(String code){
        switch(code) {
            case "ce":
                return CE;
            case "qd":
                return QD;
            case "sk":
                return SK;
            default:
                return null;
        }
    }
}
