package com.xforceplus.ultraman.app.jccr39.controller;


/**
 * 应用配置系统对象feign客户端
 *
 * @author ultraman
 * @date 2025-09-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccr39.entity.SystemConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cr39")
public interface SystemConfigFeignApi {

  /**
   * 通过id查询应用配置系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应用配置系统对象
   * @param systemConfig 应用配置系统对象
   * @return R
   */
  @PostMapping("/systemConfig/add")
  public R save(@RequestBody SystemConfig systemConfig);

  /**
   * 修改应用配置系统对象
   * @param systemConfig 应用配置系统对象
   * @return R
   */
  @PostMapping("/systemConfig/update")
  public R updateById(@RequestBody SystemConfig systemConfig);

  /**
   * 通过id删除应用配置系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}