package com.xforceplus.ultraman.app.jccr39.controller;


/**
 * 领域扩展字段系统对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccr39.entity.SystemExtendDomainField;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cr39")
public interface SystemExtendDomainFieldFeignApi {

  /**
   * 通过id查询领域扩展字段系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemExtendDomainField/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增领域扩展字段系统对象
   * @param systemExtendDomainField 领域扩展字段系统对象
   * @return R
   */
  @PostMapping("/systemExtendDomainField/add")
  public R save(@RequestBody SystemExtendDomainField systemExtendDomainField);

  /**
   * 修改领域扩展字段系统对象
   * @param systemExtendDomainField 领域扩展字段系统对象
   * @return R
   */
  @PostMapping("/systemExtendDomainField/update")
  public R updateById(@RequestBody SystemExtendDomainField systemExtendDomainField);

  /**
   * 通过id删除领域扩展字段系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemExtendDomainField/del/{id}" )
  public R removeById(@PathVariable Long id);

}