package com.xforceplus.ultraman.app.jccr39.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compare_result
 * </p>
 *
 * @author ultraman
 * @since 2025-10-10
 */
public enum CompareResult {

    _0("0", "不一致"),
    _1("1", "一致"),
    _2("2", "购方名称不一致"),
    _3("3", "购方税号不一致"),
    _4("4", "销方名称不一致"),
    _5("5", "销方税号不一致"),
    _6("6", "红冲原因不一致"),
    _7("7", "含税金额不一致"),
    _8("8", "税收分类编码不一致"),
    _9("9", "商品名称不一致"),
    _10("10", "税率不一致");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CompareResult(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompareResult fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
