package com.xforceplus.ultraman.app.jccr39.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compare_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-10
 */
public enum CompareType {

    _0("0", "比对不通过"),
    _1("1", "比对通过但红字确认单未完全确认"),
    _2("2", "比对通过且红字确认单完全确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CompareType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompareType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
