package com.xforceplus.ultraman.app.jccr39.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compare_result
 * </p>
 *
 * @author ultraman
 * @since 2025-10-29
 */
public enum CompareResult {

    _0("0", "不一致"),
    _1("1", "一致"),
    _2("2", "购方名称不一致"),
    _3("3", "购方税号不一致"),
    _4("4", "销方名称不一致"),
    _5("5", "销方税号不一致"),
    _6("6", "红冲原因不一致"),
    _7("7", "含税金额不一致"),
    _8("8", "税收分类编码不一致"),
    _9("9", "商品名称不一致"),
    _10("10", "税率不一致");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CompareResult(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompareResult fromCode(String code) {
        return Stream.of(CompareResult.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
