package com.xforceplus.ultraman.app.jccr39.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compare_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-29
 */
public enum CompareType {

    _0("0", "比对不通过"),
    _1("1", "比对通过但红字确认单未完全确认"),
    _2("2", "比对通过且红字确认单完全确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CompareType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompareType fromCode(String code) {
        return Stream.of(CompareType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
