package com.xforceplus.ultraman.app.jccr39.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cp_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-29
 */
public enum CpStatus {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CpStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CpStatus fromCode(String code) {
        return Stream.of(CpStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
