package com.xforceplus.ultraman.app.jccr39.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cx_bill_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-29
 */
public enum CxBillType {

    对账单("对账单", "对账单"),
    确认函("确认函", "确认函");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CxBillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CxBillType fromCode(String code) {
        return Stream.of(CxBillType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
