package com.xforceplus.ultraman.app.jccr39.metadata.validator;

import com.xforceplus.ultraman.app.jccr39.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jccr39.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-10-29
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = null != ReadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = null != CreateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = null != EnableStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = null != VariableType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = null != WorkflowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedReason.class)) {
            isValid = null != RedReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedReason.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareStatus.class)) {
            isValid = null != CompareStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompareStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CxBillType.class)) {
            isValid = null != CxBillType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CxBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareResult.class)) {
            isValid = null != CompareResult.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompareResult.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = null != ApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareType.class)) {
            isValid = null != CompareType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompareType.class.getSimpleName());
            }
        }
        if(clazz.equals(CpStatus.class)) {
            isValid = null != CpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CpStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
