package com.xforceplus.ultraman.app.jccr39.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_reason
 * </p>
 *
 * @author ultraman
 * @since 2025-09-22
 */
public enum RedReason {

    _0("0", "销售退回"),
    _1("1", "开票有误"),
    _2("2", "应税服务终止"),
    _3("3", "发生销售折让");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedReason fromCode(String code) {
        return Stream.of(RedReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
