package com.xforceplus.ultraman.app.jccr39.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * variable_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-10
 */
public enum VariableType {

    FORM_VARIABLE("formVariable", "表单变量"),
    SYSTEM_VARIABLE("systemVariable", "系统变量"),
    CUSTOM_VARIABLE("customVariable", "自定义变量");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VariableType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VariableType fromCode(String code) {
        return Stream.of(VariableType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
