package com.xforceplus.ultraman.app.jccr39.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * compare_red_letters
 * </p>
 *
 * @author ultraman
 * @since 2025-10-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompareRedLetters implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 货物或应税劳务名称
   */
  private String billItemName;
  /**
   * 销方名称
   */
  private String billSellerName;
  /**
   * 销方税号
   */
  private String billSellerTaxNo;
  /**
   * 红冲原因
   */
  private String billApplyReason;
  /**
   * 含税金额
   */
  private BigDecimal billAmountWithTax;
  /**
   * 购方名称
   */
  private String redBuyerName;
  /**
   * 税收分类编码
   */
  private String billGoodsTaxNo;
  /**
   * 税率
   */
  private BigDecimal billTaxRate;
  /**
   * 货物或应税劳务名称
   */
  private String redItemName;
  /**
   * 购方税号
   */
  private String redBuyerTaxNo;
  /**
   * 红冲原因
   */
  private String redApplyReason;
  /**
   * 含税金额
   */
  private BigDecimal redAmountWithTax;
  /**
   * 税率
   */
  private BigDecimal redTaxRate;
  /**
   * 税收分类编码
   */
  private String redGoodsTaxNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 兑付单号
   */
  private String bizOrderNo;
  /**
   * 单据明细id
   */
  private String bizOrderItemId;
  /**
   * 发票明细id
   */
  private String redItemId;
  /**
   * 对比结果
   */
  private String compareResult;
  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 对一关联关系 关联对象 bizOrder
   */
  private Long bizOrderAndCompareRedLettersId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("billItemName", billItemName);
      map.put("billSellerName", billSellerName);
      map.put("billSellerTaxNo", billSellerTaxNo);
      map.put("billApplyReason", billApplyReason);
      map.put("billAmountWithTax", billAmountWithTax);
      map.put("redBuyerName", redBuyerName);
      map.put("billGoodsTaxNo", billGoodsTaxNo);
      map.put("billTaxRate", billTaxRate);
      map.put("redItemName", redItemName);
      map.put("redBuyerTaxNo", redBuyerTaxNo);
      map.put("redApplyReason", redApplyReason);
      map.put("redAmountWithTax", redAmountWithTax);
      map.put("redTaxRate", redTaxRate);
      map.put("redGoodsTaxNo", redGoodsTaxNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bizOrderNo", bizOrderNo);
      map.put("bizOrderItemId", bizOrderItemId);
      map.put("redItemId", redItemId);
      map.put("compareResult", compareResult);
      map.put("org_tree", orgTree);

      map.put("bizOrderAndCompareRedLetters.id", bizOrderAndCompareRedLettersId);
      return map;
  }

  public static CompareRedLetters fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    CompareRedLetters entity = new CompareRedLetters();

    if(map.containsKey("billItemName")) {
      Object obj = map.get("billItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billSellerName")) {
      Object obj = map.get("billSellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billSellerTaxNo")) {
      Object obj = map.get("billSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billApplyReason")) {
      Object obj = map.get("billApplyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billAmountWithTax")) {
      Object obj = map.get("billAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redBuyerName")) {
      Object obj = map.get("redBuyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billGoodsTaxNo")) {
      Object obj = map.get("billGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billTaxRate")) {
      Object obj = map.get("billTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redItemName")) {
      Object obj = map.get("redItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redBuyerTaxNo")) {
      Object obj = map.get("redBuyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redApplyReason")) {
      Object obj = map.get("redApplyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redTaxRate")) {
      Object obj = map.get("redTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redGoodsTaxNo")) {
      Object obj = map.get("redGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderItemId")) {
      Object obj = map.get("bizOrderItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redItemId")) {
      Object obj = map.get("redItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compareResult")) {
      Object obj = map.get("compareResult");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompareResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("bizOrderAndCompareRedLetters.id")) {
       Object obj = map.get("bizOrderAndCompareRedLetters.id");
       if(obj instanceof Long) {
         entity.setBizOrderAndCompareRedLettersId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setBizOrderAndCompareRedLettersId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billItemName")) {
      Object obj = map.get("billItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billSellerName")) {
      Object obj = map.get("billSellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billSellerTaxNo")) {
      Object obj = map.get("billSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billApplyReason")) {
      Object obj = map.get("billApplyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billAmountWithTax")) {
      Object obj = map.get("billAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redBuyerName")) {
      Object obj = map.get("redBuyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billGoodsTaxNo")) {
      Object obj = map.get("billGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billTaxRate")) {
      Object obj = map.get("billTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redItemName")) {
      Object obj = map.get("redItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redBuyerTaxNo")) {
      Object obj = map.get("redBuyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redApplyReason")) {
      Object obj = map.get("redApplyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redTaxRate")) {
      Object obj = map.get("redTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRedTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRedTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRedTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRedTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redGoodsTaxNo")) {
      Object obj = map.get("redGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderItemId")) {
      Object obj = map.get("bizOrderItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBizOrderItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redItemId")) {
      Object obj = map.get("redItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compareResult")) {
      Object obj = map.get("compareResult");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompareResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("bizOrderAndCompareRedLetters.id")) {
    Object obj = map.get("bizOrderAndCompareRedLetters.id");
    if(obj instanceof Long) {
        this.setBizOrderAndCompareRedLettersId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setBizOrderAndCompareRedLettersId(Long.parseLong((String)obj));
    }
  }
  }
}
