package com.xforceplus.ultraman.app.jccr39.metadata.validator;

import com.xforceplus.ultraman.app.jccr39.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jccr39.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-10-10
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnableStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VariableType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WorkflowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedReason.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompareStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompareStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CxBillType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CxBillType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CxBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareResult.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompareResult.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompareResult.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompareType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompareType.class.getSimpleName());
            }
        }
        if(clazz.equals(CpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CpStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
