package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * product_type
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
public enum ProductType {

    住宅("住宅", "住宅"),
    公寓("公寓", "公寓"),
    写字楼("写字楼", "写字楼"),
    购物中心("购物中心", "购物中心"),
    酒店("酒店", "酒店"),
    车位("车位", "车位"),
    商铺("商铺", "商铺"),
    配套("配套", "配套"),
    储藏室("储藏室", "储藏室"),
    万象影院("万象影院", "万象影院");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProductType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductType fromCode(String code){
        switch(code) {
            case "住宅":
                return 住宅;
            case "公寓":
                return 公寓;
            case "写字楼":
                return 写字楼;
            case "购物中心":
                return 购物中心;
            case "酒店":
                return 酒店;
            case "车位":
                return 车位;
            case "商铺":
                return 商铺;
            case "配套":
                return 配套;
            case "储藏室":
                return 储藏室;
            case "万象影院":
                return 万象影院;
            default:
                return null;
        }
    }
}
