package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_source_enum
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
public enum TaxInvoiceSourceEnum {

    QD("qd", "数电"),
    SK("sk", "税控");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxInvoiceSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSourceEnum fromCode(String code){
        switch(code) {
            case "qd":
                return QD;
            case "sk":
                return SK;
            default:
                return null;
        }
    }
}
