package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_business_type
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
public enum YxBusinessType {

    SETTLEMENT("SETTLEMENT", "结算"),
    ADVANCE("ADVANCE", "预收");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxBusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxBusinessType fromCode(String code){
        switch(code) {
            case "SETTLEMENT":
                return SETTLEMENT;
            case "ADVANCE":
                return ADVANCE;
            default:
                return null;
        }
    }
}
