package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_car_quantity_unit
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
public enum YxCarQuantityUnit {

    _1("1", "平方米");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxCarQuantityUnit(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxCarQuantityUnit fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
