package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_quantity_area
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
public enum YxQuantityArea {

    _0("0", "实测建筑面积"),
    _1("1", "预测建筑面积"),
    _2("2", "实测套内面积"),
    _3("3", "预测套内面积"),
    _4("4", "成交面积"),
    _5("5", "成交单价");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxQuantityArea(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxQuantityArea fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
