package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_remark
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
public enum YxRemark {

    _0("0", "项目名称"),
    _1("1", "产品类型"),
    _2("2", "房间名称"),
    _3("3", "蓝牌地址"),
    _4("4", "项目地址"),
    _5("5", "房间备案名称");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxRemark(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxRemark fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
