package com.xforceplus.ultraman.app.jccrland.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompareBillInvoice implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 货物或应税劳务名称
   */
  @TableField("billItemName")
  private String billItemName;

  /**
   * 规格型号
   */
  @TableField("billItemSpec")
  private String billItemSpec;

  /**
   * 单位
   */
  @TableField("billQuantityUnit")
  private String billQuantityUnit;

  /**
   * 数量
   */
  @TableField("billQuantity")
  private BigDecimal billQuantity;

  /**
   * 单价
   */
  @TableField("billUnitPrice")
  private BigDecimal billUnitPrice;

  /**
   * 含税金额
   */
  @TableField("billAmountWithTax")
  private BigDecimal billAmountWithTax;

  /**
   * 不含税金额
   */
  @TableField("billAmountWithoutTax")
  private BigDecimal billAmountWithoutTax;

  /**
   * 税额
   */
  @TableField("billTaxAmount")
  private BigDecimal billTaxAmount;

  /**
   * 税收分类编码
   */
  @TableField("billGoodsTaxNo")
  private String billGoodsTaxNo;

  /**
   * 税率
   */
  @TableField("billTaxRate")
  private BigDecimal billTaxRate;

  /**
   * 货物或应税劳务名称
   */
  @TableField("invoiceItemName")
  private String invoiceItemName;

  /**
   * 规格型号
   */
  @TableField("invoiceItemSpec")
  private String invoiceItemSpec;

  /**
   * 单位
   */
  @TableField("invoiceQuantityUnit")
  private String invoiceQuantityUnit;

  /**
   * 数量
   */
  @TableField("invoiceQuantity")
  private BigDecimal invoiceQuantity;

  /**
   * 单价
   */
  @TableField("invoiceUnitPrice")
  private BigDecimal invoiceUnitPrice;

  /**
   * 含税金额
   */
  @TableField("invoiceAmountWithTax")
  private BigDecimal invoiceAmountWithTax;

  /**
   * 不含税金额
   */
  @TableField("invoiceAmountWithoutTax")
  private BigDecimal invoiceAmountWithoutTax;

  /**
   * 税率
   */
  @TableField("invoiceTaxRate")
  private BigDecimal invoiceTaxRate;

  /**
   * 税额
   */
  @TableField("invoiceTaxAmount")
  private BigDecimal invoiceTaxAmount;

  /**
   * 税收分类编码
   */
  @TableField("invoiceGoodsTaxNo")
  private String invoiceGoodsTaxNo;

  /**
   * 对比结果
   */
  @TableField("compareResult")
  private String compareResult;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 业务单号
   */
  @TableField("bizOrderNo")
  private String bizOrderNo;

  /**
   * 单据明细id
   */
  @TableField("bizOrderItemId")
  private String bizOrderItemId;

  /**
   * 发票明细id
   */
  @TableField("invoiceItemId")
  private String invoiceItemId;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 bizOrder
   */
    private Long cywdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billItemName", billItemName);
      map.put("billItemSpec", billItemSpec);
      map.put("billQuantityUnit", billQuantityUnit);
      map.put("billQuantity", billQuantity);
      map.put("billUnitPrice", billUnitPrice);
      map.put("billAmountWithTax", billAmountWithTax);
      map.put("billAmountWithoutTax", billAmountWithoutTax);
      map.put("billTaxAmount", billTaxAmount);
      map.put("billGoodsTaxNo", billGoodsTaxNo);
      map.put("billTaxRate", billTaxRate);
      map.put("invoiceItemName", invoiceItemName);
      map.put("invoiceItemSpec", invoiceItemSpec);
      map.put("invoiceQuantityUnit", invoiceQuantityUnit);
      map.put("invoiceQuantity", invoiceQuantity);
      map.put("invoiceUnitPrice", invoiceUnitPrice);
      map.put("invoiceAmountWithTax", invoiceAmountWithTax);
      map.put("invoiceAmountWithoutTax", invoiceAmountWithoutTax);
      map.put("invoiceTaxRate", invoiceTaxRate);
      map.put("invoiceTaxAmount", invoiceTaxAmount);
      map.put("invoiceGoodsTaxNo", invoiceGoodsTaxNo);
      map.put("compareResult", compareResult);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bizOrderNo", bizOrderNo);
      map.put("bizOrderItemId", bizOrderItemId);
      map.put("invoiceItemId", invoiceItemId);
      map.put("org_tree", orgTree);

       map.put("cywd.id", cywdId);
      return map;
  }

  public static CompareBillInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CompareBillInvoice entity = new CompareBillInvoice();
    if(map.containsKey("billItemName")) {
      Object obj = map.get("billItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billItemSpec")) {
      Object obj = map.get("billItemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billQuantityUnit")) {
      Object obj = map.get("billQuantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billQuantity")) {
      Object obj = map.get("billQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billUnitPrice")) {
      Object obj = map.get("billUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billAmountWithTax")) {
      Object obj = map.get("billAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billAmountWithoutTax")) {
      Object obj = map.get("billAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billTaxAmount")) {
      Object obj = map.get("billTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billGoodsTaxNo")) {
      Object obj = map.get("billGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billTaxRate")) {
      Object obj = map.get("billTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceItemName")) {
      Object obj = map.get("invoiceItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceItemSpec")) {
      Object obj = map.get("invoiceItemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceQuantityUnit")) {
      Object obj = map.get("invoiceQuantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceQuantity")) {
      Object obj = map.get("invoiceQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUnitPrice")) {
      Object obj = map.get("invoiceUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithoutTax")) {
      Object obj = map.get("invoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTaxRate")) {
      Object obj = map.get("invoiceTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTaxAmount")) {
      Object obj = map.get("invoiceTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceGoodsTaxNo")) {
      Object obj = map.get("invoiceGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compareResult")) {
      Object obj = map.get("compareResult");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompareResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderItemId")) {
      Object obj = map.get("bizOrderItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceItemId")) {
      Object obj = map.get("invoiceItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("cywd.id")) {
        Object obj = map.get("cywd.id");
      if(obj instanceof Long) {
        entity.setCywdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setCywdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billItemName")) {
      Object obj = map.get("billItemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billItemSpec")) {
      Object obj = map.get("billItemSpec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billQuantityUnit")) {
      Object obj = map.get("billQuantityUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billQuantity")) {
      Object obj = map.get("billQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("billUnitPrice")) {
      Object obj = map.get("billUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("billAmountWithTax")) {
      Object obj = map.get("billAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("billAmountWithoutTax")) {
      Object obj = map.get("billAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("billTaxAmount")) {
      Object obj = map.get("billTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("billGoodsTaxNo")) {
      Object obj = map.get("billGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billTaxRate")) {
      Object obj = map.get("billTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceItemName")) {
      Object obj = map.get("invoiceItemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceItemSpec")) {
      Object obj = map.get("invoiceItemSpec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceQuantityUnit")) {
      Object obj = map.get("invoiceQuantityUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceQuantity")) {
      Object obj = map.get("invoiceQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceUnitPrice")) {
      Object obj = map.get("invoiceUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmountWithoutTax")) {
      Object obj = map.get("invoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceTaxRate")) {
      Object obj = map.get("invoiceTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceTaxAmount")) {
      Object obj = map.get("invoiceTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceGoodsTaxNo")) {
      Object obj = map.get("invoiceGoodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compareResult")) {
      Object obj = map.get("compareResult");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompareResult((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizOrderItemId")) {
      Object obj = map.get("bizOrderItemId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceItemId")) {
      Object obj = map.get("invoiceItemId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("cywd.id")) {
        Object obj = map.get("cywd.id");
        if(obj instanceof Long) {
          this.setCywdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCywdId(Long.parseLong((String)obj));
        }
      }
  }
}
