package com.xforceplus.ultraman.app.jccrland.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class YxMakeInvoiceSetting implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业态
   */
  @TableField("makeInvoiceType")
  private String makeInvoiceType;

  /**
   * 业务种类
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 国税发票来源
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * 购方名称
   */
  @TableField("purchaserNameShow")
  private String purchaserNameShow;

  /**
   * 数量面积
   */
  @TableField("quantityArea")
  private String quantityArea;

  /**
   * 车位数量单位
   */
  @TableField("carQuantityUnit")
  private String carQuantityUnit;

  /**
   * 数量单价是否为空
   */
  @TableField("quantityUnitIsNull")
  private String quantityUnitIsNull;

  /**
   * 货物及劳务名称
   */
  @TableField("cargoName")
  private String cargoName;

  /**
   * 备注规则
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否允许客户在个税APP查询
   */
  @TableField("taxSelect")
  private String taxSelect;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 projectSelect
   */
    private Long projectLinkId;
  /**
   * 对一关联关系 关联对象 cityCompany
   */
    private Long cityCompanyLinkId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("makeInvoiceType", makeInvoiceType);
      map.put("businessType", businessType);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("purchaserNameShow", purchaserNameShow);
      map.put("quantityArea", quantityArea);
      map.put("carQuantityUnit", carQuantityUnit);
      map.put("quantityUnitIsNull", quantityUnitIsNull);
      map.put("cargoName", cargoName);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("taxSelect", taxSelect);
      map.put("org_tree", orgTree);

       map.put("projectLink.id", projectLinkId);
       map.put("cityCompanyLink.id", cityCompanyLinkId);
      return map;
  }

  public static YxMakeInvoiceSetting fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    YxMakeInvoiceSetting entity = new YxMakeInvoiceSetting();
    if(map.containsKey("makeInvoiceType")) {
      Object obj = map.get("makeInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNameShow")) {
      Object obj = map.get("purchaserNameShow");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNameShow((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityArea")) {
      Object obj = map.get("quantityArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carQuantityUnit")) {
      Object obj = map.get("carQuantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCarQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnitIsNull")) {
      Object obj = map.get("quantityUnitIsNull");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnitIsNull((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxSelect")) {
      Object obj = map.get("taxSelect");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxSelect((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("projectLink.id")) {
        Object obj = map.get("projectLink.id");
      if(obj instanceof Long) {
        entity.setProjectLinkId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setProjectLinkId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("cityCompanyLink.id")) {
        Object obj = map.get("cityCompanyLink.id");
      if(obj instanceof Long) {
        entity.setCityCompanyLinkId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setCityCompanyLinkId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("makeInvoiceType")) {
      Object obj = map.get("makeInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNameShow")) {
      Object obj = map.get("purchaserNameShow");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNameShow((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantityArea")) {
      Object obj = map.get("quantityArea");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("carQuantityUnit")) {
      Object obj = map.get("carQuantityUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCarQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantityUnitIsNull")) {
      Object obj = map.get("quantityUnitIsNull");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnitIsNull((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCargoName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxSelect")) {
      Object obj = map.get("taxSelect");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxSelect((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("projectLink.id")) {
        Object obj = map.get("projectLink.id");
        if(obj instanceof Long) {
          this.setProjectLinkId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProjectLinkId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("cityCompanyLink.id")) {
        Object obj = map.get("cityCompanyLink.id");
        if(obj instanceof Long) {
          this.setCityCompanyLinkId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCityCompanyLinkId(Long.parseLong((String)obj));
        }
      }
  }
}
