package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_pre_con
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum TaxPreCon {

    _0("0", "无"),
    _1("1", "不征税"),
    _2("2", "免税"),
    _3("3", "按5%简易征收减按1.5%计证"),
    _4("4", "按3%简易征收"),
    _5("5", "按5%简易征收"),
    _6("6", "简易征收"),
    _7("7", "100%先征后退"),
    _8("8", "50%先征后退"),
    _9("9", "先征后退"),
    _10("10", "即征即退100%"),
    _11("11", "按5%简易征收减按1.5%计证"),
    _12("12", "即征即退30%"),
    _13("13", "即征即退50%"),
    _14("14", "即征即退70%"),
    _15("15", "稀土产品"),
    _16("16", "超税负12%即征即退"),
    _17("17", "超税负3%即征即退"),
    _18("18", "超税负6%即征即退"),
    _19("19", "超税负8%即征即退");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxPreCon(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxPreCon fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            default:
                return null;
        }
    }
}
