package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_rate
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum TaxRate {

    _0("0", "0%"),
    _1("1", "0.5%"),
    _2("2", "1%"),
    _3("3", "1.5%"),
    _4("4", "2%"),
    _5("5", "3%"),
    _6("6", "5%"),
    _7("7", "6%"),
    _8("8", "9%"),
    _9("9", "10%"),
    _10("10", "11%"),
    _11("11", "13%"),
    _12("12", "16%"),
    _13("13", "17%");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxRate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxRate fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            default:
                return null;
        }
    }
}
