package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_business_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum YxBusinessType {

    预收("预收", "预收"),
    结算("结算", "结算");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxBusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxBusinessType fromCode(String code){
        switch(code) {
            case "预收":
                return 预收;
            case "结算":
                return 结算;
            default:
                return null;
        }
    }
}
