package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_cargo_name
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum YxCargoName {

    项目分期名称("项目分期名称", "项目分期名称"),
    项目名称("项目名称", "项目名称"),
    产品类型("产品类型", "产品类型"),
    房间全称("房间全称", "房间全称"),
    房间备案名称("房间备案名称", "房间备案名称");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxCargoName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxCargoName fromCode(String code){
        switch(code) {
            case "项目分期名称":
                return 项目分期名称;
            case "项目名称":
                return 项目名称;
            case "产品类型":
                return 产品类型;
            case "房间全称":
                return 房间全称;
            case "房间备案名称":
                return 房间备案名称;
            default:
                return null;
        }
    }
}
