package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_make_invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum YxMakeInvoiceType {

    销售物业("销售物业", "销售物业");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxMakeInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxMakeInvoiceType fromCode(String code){
        switch(code) {
            case "销售物业":
                return 销售物业;
            default:
                return null;
        }
    }
}
