package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_purchaser_name_show
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum YxPurchaserNameShow {

    不拆分购方名称("不拆分购方名称", "不拆分购方名称"),
    拆分购方名称("拆分购方名称", "拆分购方名称");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxPurchaserNameShow(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxPurchaserNameShow fromCode(String code){
        switch(code) {
            case "不拆分购方名称":
                return 不拆分购方名称;
            case "拆分购方名称":
                return 拆分购方名称;
            default:
                return null;
        }
    }
}
