package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_quantity_area
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum YxQuantityArea {

    实测建筑面积("实测建筑面积", "实测建筑面积"),
    预测建筑面积("预测建筑面积", "预测建筑面积"),
    实测套内面积("实测套内面积", "实测套内面积"),
    预测套内面积("预测套内面积", "预测套内面积");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxQuantityArea(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxQuantityArea fromCode(String code){
        switch(code) {
            case "实测建筑面积":
                return 实测建筑面积;
            case "预测建筑面积":
                return 预测建筑面积;
            case "实测套内面积":
                return 实测套内面积;
            case "预测套内面积":
                return 预测套内面积;
            default:
                return null;
        }
    }
}
