package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_quantity_unit_is_null
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum YxQuantityUnitIsNull {

    是("是", "是"),
    否("否", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxQuantityUnitIsNull(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxQuantityUnitIsNull fromCode(String code){
        switch(code) {
            case "是":
                return 是;
            case "否":
                return 否;
            default:
                return null;
        }
    }
}
