package com.xforceplus.ultraman.app.jccrland.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yx_remark
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
public enum YxRemark {

    项目名称("项目名称", "项目名称"),
    产品类型("产品类型", "产品类型"),
    房间全称("房间全称", "房间全称"),
    蓝牌地址("蓝牌地址", "蓝牌地址"),
    项目地址("项目地址", "项目地址");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YxRemark(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YxRemark fromCode(String code){
        switch(code) {
            case "项目名称":
                return 项目名称;
            case "产品类型":
                return 产品类型;
            case "房间全称":
                return 房间全称;
            case "蓝牌地址":
                return 蓝牌地址;
            case "项目地址":
                return 项目地址;
            default:
                return null;
        }
    }
}
