package com.xforceplus.ultraman.app.jccrland.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-10-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 单据状态
   */
  private String status;

  /**
   * 发票备注
   */
  private String remark;

  /**
   * 购方抬头
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 公司地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 公司电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 收款人姓名
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人姓名
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 系统来源 
   */
  @TableField("originCode")
  private String originCode;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 红冲开具原因
   */
  @TableField("redReason")
  private String redReason;

  /**
   * 红字信息编号
   */
  @TableField("redNotification")
  private String redNotification;

  /**
   * 原发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 原开票日期
   */
  @TableField("originPaperDrawDate")
  private String originPaperDrawDate;

  /**
   * 国税发票来源
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * 比对状态
   */
  @TableField("compareStatus")
  private String compareStatus;

  /**
   * 业务单类型
   */
  @TableField("salesbillType")
  private String salesbillType;

  /**
   * 错误信息
   */
  private String message;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesbillNo", salesbillNo);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("invoiceType", invoiceType);
      map.put("status", status);
      map.put("remark", remark);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("originCode", originCode);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redReason", redReason);
      map.put("redNotification", redNotification);
      map.put("originInvoiceType", originInvoiceType);
      map.put("originPaperDrawDate", originPaperDrawDate);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("compareStatus", compareStatus);
      map.put("salesbillType", salesbillType);
      map.put("message", message);

      return map;
  }

  public static BizOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOrder entity = new BizOrder();
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originCode")) {
      Object obj = map.get("originCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redReason")) {
      Object obj = map.get("redReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotification")) {
      Object obj = map.get("redNotification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compareStatus")) {
      Object obj = map.get("compareStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompareStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("message")) {
      Object obj = map.get("message");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMessage((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originCode")) {
      Object obj = map.get("originCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redReason")) {
      Object obj = map.get("redReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redNotification")) {
      Object obj = map.get("redNotification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginPaperDrawDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compareStatus")) {
      Object obj = map.get("compareStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompareStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("message")) {
      Object obj = map.get("message");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMessage((String)obj);
        }
      } else {
      }
    }
  }
}
