package com.xforceplus.ultraman.app.jccrland.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-08-20
 */
public enum InvoiceType {

    QS("qs", "电子发票(增值税专用发票)"),
    QC("qc", "电子发票(普通发票)");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code) {
        return Stream.of(InvoiceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
