package com.xforceplus.ultraman.app.jccrland.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compare_result
 * </p>
 *
 * @author ultraman
 * @since 2024-08-20
 */
public enum CompareResult {

    _0("0", "不一致"),
    _1("1", "一致");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CompareResult(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompareResult fromCode(String code) {
        return Stream.of(CompareResult.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
