package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.CompareBillInvoice;
import com.xforceplus.ultraman.app.jccrland.service.ICompareBillInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-01
 */
@RestController
public class CompareBillInvoiceController {

  @Autowired
  private ICompareBillInvoiceService compareBillInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareBillInvoice ${table.comment}
   * @return
   */
  @GetMapping("/comparebillinvoices" )
  public XfR getCompareBillInvoices(XfPage page, CompareBillInvoice compareBillInvoice) {
    return XfR.ok(compareBillInvoiceServiceImpl.page(page, Wrappers.query(compareBillInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparebillinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareBillInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareBillInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/comparebillinvoices")
  public XfR save(@RequestBody CompareBillInvoice compareBillInvoice) {
     return XfR.ok(compareBillInvoiceServiceImpl.save(compareBillInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareBillInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/comparebillinvoices/{id}")
  public XfR putUpdate(@RequestBody CompareBillInvoice compareBillInvoice,@PathVariable Long id) {
      compareBillInvoice.setId(id);
      return XfR.ok(compareBillInvoiceServiceImpl.updateById(compareBillInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareBillInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/comparebillinvoices/{id}")
  public XfR patchUpdate(@RequestBody CompareBillInvoice compareBillInvoice,@PathVariable Long id) {
      CompareBillInvoice upcompareBillInvoice = compareBillInvoiceServiceImpl.getById(id);
      if(upcompareBillInvoice != null){
        upcompareBillInvoice = ObjectCopyUtils.copyProperties(compareBillInvoice,upcompareBillInvoice,true);
      }
      return XfR.ok(compareBillInvoiceServiceImpl.updateById(upcompareBillInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparebillinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareBillInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/comparebillinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_bill_invoice");
     params.put("request", condition);

     return XfR.ok(compareBillInvoiceServiceImpl.querys(params));
  }

}
